﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Kz.GammaTech.Tsp;
using System.IO;
using Kz.GammaTech.Crypto.Parameters;
using Kz.GammaTech.X509;
using Kz.GammaTech.X509.Store;
using Kz.GammaTech.Asn1.X509;
using Kz.GammaTech.Pkcs;
using Kz.GammaTech.Crypto;
using Kz.GammaTech.Crypto.Digests;
using Kz.GammaTech.Asn1.Gamma;
using System.DirectoryServices.Protocols;
using Kz.GammaTech.Cms;
using Kz.GammaTech.Asn1.Cms;
using System.Collections;

namespace ExampleTSP
{
    class Program
    {
        static void Main(string[] args)
        {
                    
            TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
            Gost3411Digest dig = new Gost3411Digest();
            string mess = "test";          
            dig.BlockUpdate(System.Text.Encoding.ASCII.GetBytes(mess), 0, mess.Length);
            byte[] hash_arr = new byte[32];
            int r = dig.DoFinal(hash_arr, 0);
            TimeStampRequest tsp_req = reqGen.Generate(GammaObjectIdentifiers.GostR3411.Id, hash_arr);             
            LdapDirectoryIdentifier dir_id = new LdapDirectoryIdentifier("127.0.0.1", 62222);
            LdapConnection ldap_connect = new LdapConnection(dir_id);
            ldap_connect.AuthType = AuthType.Basic;
            ldap_connect.Bind();
            ExtendedRequest ldap_req = new ExtendedRequest("1.3.6.1.4.1.6801.11.1.2", tsp_req.GetEncoded());
            DirectoryResponse ldap_resp = ldap_connect.SendRequest(ldap_req);
            ExtendedResponse ldap_resp2 = (ExtendedResponse)ldap_resp;            
            TimeStampResponse tsp_resp = new TimeStampResponse(ldap_resp2.ResponseValue);
            tsp_resp.Validate(tsp_req);                                             
            TimeStampTokenInfo token_info = tsp_resp.TimeStampToken.TimeStampInfo;           
            Console.WriteLine(token_info.GenTime.ToLongDateString());        
            Console.ReadKey();
                

        }
    }
}
